/*
 * Decompiled with CFR 0.152.
 */
package io.ipfs.api;

import io.ipfs.api.JSONParser;
import io.ipfs.multihash.Multihash;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class MerkleNode {
    public final Multihash hash;
    public final Optional<String> name;
    public final Optional<Integer> size;
    public final Optional<Integer> type;
    public final List<MerkleNode> links;
    public final Optional<byte[]> data;

    public MerkleNode(String hash) {
        this(hash, Optional.empty());
    }

    public MerkleNode(String hash, Optional<String> name) {
        this(hash, name, Optional.empty(), Optional.empty(), Arrays.asList(new MerkleNode[0]), Optional.empty());
    }

    public MerkleNode(String hash, Optional<String> name, Optional<Integer> size, Optional<Integer> type, List<MerkleNode> links, Optional<byte[]> data) {
        this.name = name;
        this.hash = Multihash.fromBase58(hash);
        this.size = size;
        this.type = type;
        this.links = links;
        this.data = data;
    }

    public boolean equals(Object b) {
        if (!(b instanceof MerkleNode)) {
            return false;
        }
        MerkleNode other = (MerkleNode)b;
        return this.hash.equals(other.hash);
    }

    public int hashCode() {
        return this.hash.hashCode();
    }

    public static MerkleNode fromJSON(Object rawjson) {
        Optional<Integer> optional;
        Optional<Integer> size;
        Optional<Integer> optional2;
        Optional<String> name;
        if (rawjson instanceof String) {
            return new MerkleNode((String)rawjson);
        }
        Map json = (Map)rawjson;
        String hash = (String)json.get("Hash");
        if (hash == null) {
            hash = (String)json.get("Key");
        }
        Optional<String> optional3 = name = json.containsKey("Name") ? Optional.of((String)json.get("Name")) : Optional.empty();
        if (json.containsKey("Size")) {
            Optional.empty();
            optional2 = Optional.of((Integer)json.get("Size"));
        } else {
            Optional.empty();
            optional2 = size = Optional.empty();
        }
        if (json.containsKey("Type")) {
            Optional.empty();
            optional = Optional.of((Integer)json.get("Type"));
        } else {
            Optional.empty();
            optional = Optional.empty();
        }
        Optional<Integer> type = optional;
        List linksRaw = (List)json.get("Links");
        List<MerkleNode> links = linksRaw == null ? Collections.EMPTY_LIST : linksRaw.stream().map(x -> MerkleNode.fromJSON(x)).collect(Collectors.toList());
        Optional<byte[]> data = json.containsKey("Data") ? Optional.of(((String)json.get("Data")).getBytes()) : Optional.empty();
        return new MerkleNode(hash, name, size, type, links, data);
    }

    public Object toJSON() {
        TreeMap<String, Object> res = new TreeMap<String, Object>();
        res.put("Hash", this.hash);
        res.put("Links", this.links.stream().map(x -> x.hash).collect(Collectors.toList()));
        if (this.data.isPresent()) {
            res.put("Data", this.data.get());
        }
        if (this.name.isPresent()) {
            res.put("Name", this.name.get());
        }
        if (this.size.isPresent()) {
            res.put("Size", this.size.get());
        }
        if (this.type.isPresent()) {
            res.put("Type", this.type.get());
        }
        return res;
    }

    public String toJSONString() {
        return JSONParser.toString(this.toJSON());
    }
}

