/*
 * Decompiled with CFR 0.152.
 */
package io.ipfs.api;

import io.ipfs.api.NamedStreamable;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Optional;
import java.util.Random;

public class Multipart {
    private final String boundary;
    private static final String LINE_FEED = "\r\n";
    private HttpURLConnection httpConn;
    private String charset;
    private OutputStream out;
    private PrintWriter writer;

    public Multipart(String requestURL, String charset) throws IOException {
        this.charset = charset;
        this.boundary = Multipart.createBoundary();
        URL url = new URL(requestURL);
        this.httpConn = (HttpURLConnection)url.openConnection();
        this.httpConn.setUseCaches(false);
        this.httpConn.setDoOutput(true);
        this.httpConn.setDoInput(true);
        this.httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        this.httpConn.setRequestProperty("User-Agent", "Java IPFS CLient");
        this.out = this.httpConn.getOutputStream();
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.out, charset), true);
    }

    public static String createBoundary() {
        Random r = new Random();
        String allowed = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 32; ++i) {
            b.append(allowed.charAt(r.nextInt(allowed.length())));
        }
        return b.toString();
    }

    public void addFormField(String name, String value) {
        this.writer.append("--" + this.boundary).append(LINE_FEED);
        this.writer.append("Content-Disposition: form-data; name=\"" + name + "\"").append(LINE_FEED);
        this.writer.append("Content-Type: text/plain; charset=" + this.charset).append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.append(value).append(LINE_FEED);
        this.writer.flush();
    }

    public void addSubtree(String path, File dir) throws IOException {
        String dirPath = path + (path.length() > 0 ? "/" : "") + dir.getName();
        this.addDirectoryPart(dirPath);
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.addSubtree(dirPath, f);
                continue;
            }
            this.addFilePart("file", new NamedStreamable.FileWrapper(dirPath + "/", f));
        }
    }

    public void addDirectoryPart(String path) {
        try {
            this.writer.append("--" + this.boundary).append(LINE_FEED);
            this.writer.append("Content-Disposition: file; filename=\"" + URLEncoder.encode(path, "UTF-8") + "\"").append(LINE_FEED);
            this.writer.append("Content-Type: application/x-directory").append(LINE_FEED);
            this.writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
            this.writer.append(LINE_FEED);
            this.writer.append(LINE_FEED);
            this.writer.flush();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void addFilePart(String fieldName, NamedStreamable uploadFile) throws IOException {
        int r;
        Optional<String> fileName = uploadFile.getName();
        this.writer.append("--" + this.boundary).append(LINE_FEED);
        if (!fileName.isPresent()) {
            this.writer.append("Content-Disposition: file; name=\"" + fieldName + "\";").append(LINE_FEED);
        } else {
            this.writer.append("Content-Disposition: file; filename=\"" + fileName.get() + "\"").append(LINE_FEED);
        }
        this.writer.append("Content-Type: application/octet-stream").append(LINE_FEED);
        this.writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
        this.writer.append(LINE_FEED);
        this.writer.flush();
        InputStream inputStream = uploadFile.getInputStream();
        byte[] buffer = new byte[4096];
        while ((r = inputStream.read(buffer)) != -1) {
            this.out.write(buffer, 0, r);
        }
        this.out.flush();
        inputStream.close();
        this.writer.append(LINE_FEED);
        this.writer.flush();
    }

    public void addHeaderField(String name, String value) {
        this.writer.append(name + ": " + value).append(LINE_FEED);
        this.writer.flush();
    }

    public String finish() throws IOException {
        BufferedReader reader;
        StringBuilder b = new StringBuilder();
        this.writer.append("--" + this.boundary + "--").append(LINE_FEED);
        this.writer.close();
        int status = this.httpConn.getResponseCode();
        if (status == 200) {
            String line;
            reader = new BufferedReader(new InputStreamReader(this.httpConn.getInputStream()));
            while ((line = reader.readLine()) != null) {
                b.append(line);
            }
        } else {
            try {
                String line;
                BufferedReader reader2 = new BufferedReader(new InputStreamReader(this.httpConn.getInputStream()));
                while ((line = reader2.readLine()) != null) {
                    b.append(line);
                }
                reader2.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new IOException("Server returned status: " + status + " with body: " + b.toString() + " and Trailer header: " + this.httpConn.getHeaderFields().get("Trailer"));
        }
        reader.close();
        this.httpConn.disconnect();
        return b.toString();
    }
}

