/*
 * Decompiled with CFR 0.152.
 */
package io.ipfs.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Optional;

public interface NamedStreamable {
    public InputStream getInputStream() throws IOException;

    public Optional<String> getName();

    public boolean isDirectory();

    default public byte[] getContents() throws IOException {
        int r;
        InputStream in = this.getInputStream();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] tmp = new byte[4096];
        while ((r = in.read(tmp)) >= 0) {
            bout.write(tmp, 0, r);
        }
        return bout.toByteArray();
    }

    public static class ByteArrayWrapper
    implements NamedStreamable {
        private final Optional<String> name;
        private final byte[] data;

        public ByteArrayWrapper(byte[] data) {
            this(Optional.empty(), data);
        }

        public ByteArrayWrapper(String name, byte[] data) {
            this(Optional.of(name), data);
        }

        public ByteArrayWrapper(Optional<String> name, byte[] data) {
            this.name = name;
            this.data = data;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.data);
        }

        @Override
        public Optional<String> getName() {
            return this.name;
        }
    }

    public static class FileWrapper
    implements NamedStreamable {
        private final File source;
        private final String pathPrefix;

        public FileWrapper(String pathPrefix, File source) {
            this.source = source;
            this.pathPrefix = pathPrefix;
        }

        public FileWrapper(File source) {
            this("", source);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.source);
        }

        @Override
        public boolean isDirectory() {
            return this.source.isDirectory();
        }

        public File getFile() {
            return this.source;
        }

        @Override
        public Optional<String> getName() {
            try {
                return Optional.of(URLEncoder.encode(this.pathPrefix + this.source.getName(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

