/*
 * Decompiled with CFR 0.152.
 */
package org.mcupdater.downloadlib;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.mcupdater.downloadlib.Downloadable;
import org.mcupdater.downloadlib.ProgressTracker;
import org.mcupdater.downloadlib.TaskableExecutor;
import org.mcupdater.downloadlib.TrackerListener;

public class DownloadQueue {
    private final Queue<Downloadable> processQueue = new ConcurrentLinkedQueue<Downloadable>();
    private final List<Downloadable> fullList = Collections.synchronizedList(new ArrayList());
    private final List<Downloadable> failureList = Collections.synchronizedList(new ArrayList());
    private final List<Downloadable> successList = Collections.synchronizedList(new ArrayList());
    private final List<ProgressTracker> trackers = Collections.synchronizedList(new ArrayList());
    private final TrackerListener listener;
    private final String name;
    private final AtomicInteger threadPoolRemain = new AtomicInteger();
    private final File basePath;
    private final File cachePath;
    private boolean active;
    private final String parent;
    private String mcUser = null;
    private TaskableExecutor executor = null;
    private DownloadQueue self;

    public DownloadQueue(String name, String parent, TrackerListener listener, Collection<Downloadable> queue, File basePath, File cachePath, String mcUser) {
        this(name, parent, listener, queue, basePath, cachePath);
        this.mcUser = mcUser;
        this.self = this;
    }

    public DownloadQueue(String name, String parent, TrackerListener listener, Collection<Downloadable> queue, File basePath, File cachePath) {
        this.name = name;
        this.parent = parent;
        this.listener = listener;
        if (queue != null) {
            this.addToQueue(queue);
        }
        this.basePath = basePath;
        this.cachePath = cachePath;
        this.self = this;
    }

    private void addToQueue(Collection<Downloadable> queue) {
        if (this.active) {
            throw new IllegalStateException("Download queue already active");
        }
        this.fullList.addAll(queue);
        this.processQueue.addAll(queue);
        for (Downloadable entry : queue) {
            this.trackers.add(entry.getTracker());
            entry.getTracker().setTotal(100000L);
            entry.getTracker().setQueue(this);
        }
    }

    public void processQueue(ThreadPoolExecutor tpExecutor) {
        if (this.active) {
            throw new IllegalStateException("Queue is already in progress");
        }
        this.active = true;
        if (tpExecutor instanceof TaskableExecutor) {
            this.executor = (TaskableExecutor)tpExecutor;
        }
        if (this.fullList.isEmpty()) {
            this.printMessage(this.parent + " - " + this.name + " - No files in queue");
            this.threadPoolRemain.set(1);
            tpExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    DownloadQueue.this.iterateQueue();
                }
            });
        } else {
            int maxPool = tpExecutor.getMaximumPoolSize();
            this.threadPoolRemain.set(maxPool);
            for (int threadCount = 0; threadCount < maxPool; ++threadCount) {
                tpExecutor.submit(() -> this.iterateQueue());
            }
        }
        if (this.executor != null) {
            Thread postMonitor = new Thread(() -> {
                System.out.println("DownloadQueue - postMonitor start - " + this.name);
                int count = 0;
                while (!this.executor.isTaskCompleted()) {
                    try {
                        Thread.sleep(10L);
                        if (++count < 1000) continue;
                        System.out.println("Waiting - " + this.name);
                        count = 0;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                System.out.println("DownloadQueue - Finished - " + this.name);
                this.listener.onQueueFinished(this.self);
            });
            postMonitor.start();
        } else {
            this.listener.onQueueFinished(this.self);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void iterateQueue() {
        Downloadable entry;
        while ((entry = this.processQueue.poll()) != null) {
            this.listener.printMessage("Downloading: " + entry.getFriendlyName());
            try {
                entry.download(this.basePath, this.cachePath);
                List<Downloadable> list = this.successList;
                synchronized (list) {
                    this.successList.add(entry);
                }
            }
            catch (Exception e) {
                this.listener.printMessage(entry.getFriendlyName() + " failed: " + e.getMessage());
                this.failureList.add(entry);
            }
        }
    }

    public void updateProgress() {
        this.listener.onQueueProgress(this);
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isFinished() {
        return this.processQueue.isEmpty() && this.threadPoolRemain.get() == 0 && this.executor.isShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getProgress() {
        float current = 0.0f;
        float total = 0.0f;
        List<ProgressTracker> list = this.trackers;
        synchronized (list) {
            for (ProgressTracker tracker : this.trackers) {
                total += (float)tracker.getTotal();
                current += (float)tracker.getCurrent();
            }
        }
        float result = -1.0f;
        if (total > 0.0f) {
            result = current / total;
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void printMessage(String msg) {
        this.listener.printMessage(msg);
    }

    public List<Downloadable> getFailures() {
        return this.failureList;
    }

    public List<Downloadable> getSuccesses() {
        return this.successList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalFileCount() {
        List<Downloadable> list = this.fullList;
        synchronized (list) {
            return this.fullList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSuccessFileCount() {
        List<Downloadable> list = this.successList;
        synchronized (list) {
            return this.successList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFailedFileCount() {
        List<Downloadable> list = this.failureList;
        synchronized (list) {
            return this.failureList.size();
        }
    }

    public File getCachePath() {
        return this.cachePath;
    }

    public String getParent() {
        return this.parent;
    }

    public String getMCUser() {
        return this.mcUser;
    }

    public boolean isComplete() {
        return this.executor.isShutdown();
    }
}

