/*
 * Decompiled with CFR 0.152.
 */
package org.mcupdater.downloadlib;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.io.FileUtils;
import org.mcupdater.downloadlib.Version;

public class DownloadUtil {
    public static boolean get(URL url, File dest) {
        try {
            URLConnection conn = url.getProtocol().startsWith("http") ? DownloadUtil.getMCUHttpURLConnection(url) : url.openConnection();
            conn.connect();
            FileUtils.copyInputStreamToFile(conn.getInputStream(), dest);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static HttpURLConnection getMCUHttpURLConnection(URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("User-Agent", Version.USER_AGENT);
        return conn;
    }

    public static File getToTemp(URL url, String prefix, String suffix) {
        try {
            File tmp = File.createTempFile(prefix, suffix);
            tmp.deleteOnExit();
            if (DownloadUtil.get(url, tmp)) {
                return tmp;
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

