/*
 * Decompiled with CFR 0.152.
 */
package org.mcupdater.downloadlib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.mcupdater.downloadlib.MirrorOutputStream;
import org.mcupdater.downloadlib.ProgressTracker;
import org.mcupdater.downloadlib.TrackingInputStream;
import org.mcupdater.downloadlib.Version;
import org.tukaani.xz.LZMAInputStream;
import org.tukaani.xz.XZInputStream;

public class Downloadable {
    private final String friendlyName;
    private final String filename;
    private final HashAlgorithm algo;
    private final String hash;
    private long size;
    private final List<URL> downloadURLs;
    private final ProgressTracker tracker;

    public Downloadable(String friendlyName, String filename, String md5, long size, List<URL> downloadURLs) {
        this(friendlyName, filename, HashAlgorithm.MD5, md5, size, downloadURLs);
    }

    public Downloadable(String friendlyName, String filename, HashAlgorithm algo, String hash, long size, List<URL> downloadURLs) {
        this.friendlyName = friendlyName;
        this.filename = filename;
        this.algo = algo;
        this.hash = hash;
        this.size = size;
        this.downloadURLs = downloadURLs;
        this.tracker = new ProgressTracker();
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getHash() {
        return this.hash;
    }

    public HashAlgorithm getHashAlgorithm() {
        return this.algo;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public List<URL> getURLs() {
        return this.downloadURLs;
    }

    public ProgressTracker getTracker() {
        return this.tracker;
    }

    public void download(File basePath, File cache) throws IOException {
        File cacheFile;
        this.printMessage("Started");
        String localHash = "-";
        if (basePath != null && !basePath.isDirectory()) {
            basePath.mkdirs();
        }
        File resolvedFile = new File(basePath, this.filename);
        resolvedFile.getParentFile().mkdirs();
        if (resolvedFile.isFile()) {
            localHash = Downloadable.getHash(this.algo, resolvedFile);
        }
        if (resolvedFile.isFile() && !resolvedFile.canWrite()) {
            this.printMessage("PANIC! Can't Write!");
            throw new RuntimeException("No write permissions for " + resolvedFile.toString() + "!");
        }
        if (this.nullOrEmpty(this.hash) && resolvedFile.isFile()) {
            this.printMessage("No hash and file exists - No download");
            this.tracker.setCurrent(1L);
            this.tracker.setTotal(1L);
            return;
        }
        if (localHash.equals(this.hash)) {
            this.printMessage("Hash matches - No download");
            this.tracker.setCurrent(1L);
            this.tracker.setTotal(1L);
            return;
        }
        if (cache != null && !this.nullOrEmpty(this.hash) && (cacheFile = new File(cache, this.hash.toLowerCase() + ".bin")).exists()) {
            if (!this.hash.equalsIgnoreCase(Downloadable.getHash(this.algo, cacheFile))) {
                this.printMessage("Cache file is invalid! Redownloading");
            } else {
                this.printMessage("Cache hit for hash");
                TrackingInputStream input = new TrackingInputStream(new FileInputStream(cacheFile), this.tracker);
                FileOutputStream output = new FileOutputStream(resolvedFile);
                IOUtils.copy((InputStream)input, (OutputStream)output);
                IOUtils.closeQuietly(input);
                IOUtils.closeQuietly(output);
                while (resolvedFile.getName().toLowerCase().endsWith(".xz") || resolvedFile.getName().toLowerCase().endsWith(".lzma") || resolvedFile.getName().toLowerCase().endsWith(".pack")) {
                    if (resolvedFile.getName().toLowerCase().endsWith(".xz")) {
                        resolvedFile = Downloadable.extractXZ(resolvedFile);
                        this.printMessage("Extracted: " + resolvedFile.getName());
                    }
                    if (resolvedFile.getName().toLowerCase().endsWith(".lzma")) {
                        resolvedFile = Downloadable.extractLZMA(resolvedFile);
                        this.printMessage("Extracted: " + resolvedFile.getName());
                    }
                    if (!resolvedFile.getName().toLowerCase().endsWith(".pack")) continue;
                    resolvedFile = Downloadable.unpack(resolvedFile);
                    this.printMessage("Unpacked: " + resolvedFile.getName());
                }
                return;
            }
        }
        for (URL downloadURL : this.downloadURLs) {
            try {
                URLConnection conn;
                URL localURL = downloadURL;
                if (localURL.getFile().toLowerCase().contains(".pack")) {
                    resolvedFile = new File(resolvedFile.getAbsolutePath().concat(".pack"));
                }
                if (localURL.getFile().toLowerCase().contains(".lzma")) {
                    resolvedFile = new File(resolvedFile.getAbsolutePath().concat(".lzma"));
                }
                if (localURL.getFile().toLowerCase().contains(".xz")) {
                    resolvedFile = new File(resolvedFile.getAbsolutePath().concat(".xz"));
                }
                if ((conn = this.redirectAndConnect(localURL, null)).getContentLength() > 0) {
                    this.tracker.setTotal(conn.getContentLength());
                }
                TrackingInputStream input = new TrackingInputStream(conn.getInputStream(), this.tracker);
                File cacheFile2 = this.nullOrEmpty(this.hash) ? null : new File(cache, this.hash.toLowerCase() + ".bin");
                OutputStream output = cache != null && !this.nullOrEmpty(this.hash) ? new MirrorOutputStream(resolvedFile, cacheFile2) : new FileOutputStream(resolvedFile);
                IOUtils.copy((InputStream)input, output);
                IOUtils.closeQuietly(input);
                IOUtils.closeQuietly(output);
                localHash = Downloadable.getHash(this.algo, resolvedFile);
                while (resolvedFile.getName().toLowerCase().endsWith(".xz") || resolvedFile.getName().toLowerCase().endsWith(".lzma") || resolvedFile.getName().toLowerCase().endsWith(".pack")) {
                    boolean changed = false;
                    if (resolvedFile.getName().toLowerCase().endsWith(".xz")) {
                        resolvedFile = Downloadable.extractXZ(resolvedFile);
                        changed = true;
                        this.printMessage("Extracted: " + resolvedFile.getName());
                    }
                    if (resolvedFile.getName().toLowerCase().endsWith(".lzma")) {
                        resolvedFile = Downloadable.extractLZMA(resolvedFile);
                        changed = true;
                        this.printMessage("Extracted: " + resolvedFile.getName());
                    }
                    if (resolvedFile.getName().toLowerCase().endsWith(".pack")) {
                        resolvedFile = Downloadable.unpack(resolvedFile);
                        changed = true;
                        this.printMessage("Unpacked: " + resolvedFile.getName());
                    }
                    if (!changed) continue;
                    localHash = Downloadable.getHash(this.algo, resolvedFile);
                    FileUtils.copyFile(resolvedFile, new File(cache, localHash.toLowerCase() + ".bin"));
                }
                if (this.nullOrEmpty(this.hash) || localHash.equals(this.hash)) {
                    this.printMessage("Download finished");
                    return;
                }
                this.printMessage("Hash mismatch after download!");
                if (cacheFile2.exists()) {
                    cacheFile2.delete();
                }
                return;
            }
            catch (IOException e) {
                this.printMessage(e.getMessage());
                StringWriter stack = new StringWriter();
                e.printStackTrace(new PrintWriter(stack));
                this.printMessage(stack.toString());
            }
            catch (Exception e) {
                this.printMessage("Something happened! - " + e.getMessage());
            }
        }
        this.printMessage("Unable to download");
        throw new RuntimeException("Unable to download (" + this.friendlyName + ") - All known URLs failed.");
    }

    private URLConnection redirectAndConnect(URL target, URL referer) throws IOException {
        if (target.getProtocol().equals("file")) {
            URLConnection conn = target.openConnection();
            conn.connect();
            return conn;
        }
        if (target.getHost().toLowerCase().equals("www.dropbox.com") && !target.toString().toLowerCase().contains("dl=1")) {
            target = target.toString().contains("?") ? new URL(target.toString().concat("&dl=1")) : new URL(target.toString().concat("?dl=1"));
        }
        target = new URL(this.escapeURL(target.toString()));
        HttpURLConnection conn = (HttpURLConnection)target.openConnection();
        conn.setRequestProperty("User-Agent", Version.USER_AGENT);
        if (this.tracker.getQueue() != null && this.tracker.getQueue().getMCUser() != null) {
            conn.setRequestProperty("MC-User", this.tracker.getQueue().getMCUser());
        }
        if (referer != null) {
            conn.setRequestProperty("Referer", referer.toString());
        }
        if (target.getUserInfo() != null) {
            String basicAuth = "Basic " + new String(new Base64().encode(target.getUserInfo().getBytes()));
            conn.setRequestProperty("Authorization", basicAuth);
        }
        if (target.getHost().equals("www.mediafire.com")) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOUtils.copy(conn.getInputStream(), (OutputStream)baos);
                byte[] bytes = baos.toByteArray();
                InputStreamReader in = new InputStreamReader(new ByteArrayInputStream(bytes));
                char[] buffer = new char[819200];
                StringBuilder content = new StringBuilder();
                while (in.read(buffer) != -1) {
                    content.append(buffer);
                }
                ((Reader)in).close();
                int key = content.toString().indexOf("\"", content.toString().indexOf("kNO"));
                int after = content.toString().indexOf("\"", key + 1);
                String newUrl = content.toString().substring(key + 1, after);
                System.out.println("Mediafire response - " + newUrl);
                if (newUrl.toLowerCase().startsWith("http")) {
                    return this.redirectAndConnect(new URL(newUrl), target);
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        conn.setUseCaches(false);
        conn.setInstanceFollowRedirects(false);
        if (conn.getResponseCode() / 100 == 3) {
            String newTarget = conn.getHeaderField("Location");
            if (newTarget.startsWith("//")) {
                newTarget = target.getProtocol() + ":" + newTarget;
            }
            return this.redirectAndConnect(new URL(newTarget), target);
        }
        String contentType = conn.getContentType();
        if (contentType == null) {
            this.printMessage("No content type found!  Download server may have issues.");
        } else if (contentType.toLowerCase().startsWith("text/html")) {
            String raw;
            int key;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy(conn.getInputStream(), (OutputStream)baos);
            byte[] bytes = baos.toByteArray();
            InputStreamReader in = new InputStreamReader(new ByteArrayInputStream(bytes));
            char[] buffer = new char[819200];
            StringBuilder content = new StringBuilder();
            while (in.read(buffer) != -1) {
                content.append(buffer);
            }
            ((Reader)in).close();
            if (target.getHost().equals("adf.ly") && !target.toString().startsWith("https://adf.ly/go.php")) {
                key = content.toString().indexOf("'", content.toString().indexOf("ysmm"));
                int after = content.toString().indexOf("'", key + 1);
                raw = content.toString().substring(key + 1, after);
                StringBuilder forward = new StringBuilder();
                StringBuilder backward = new StringBuilder();
                for (int i = 0; i < raw.length(); ++i) {
                    if (i % 2 == 0) {
                        forward.append(raw.charAt(i));
                        continue;
                    }
                    backward.insert(0, raw.charAt(i));
                }
                String rebuilt = forward.toString() + backward.toString();
                byte[] decode = Base64.decodeBase64(rebuilt);
                byte[] decode2 = new byte[decode.length - 2];
                System.arraycopy(decode, 2, decode2, 0, decode.length - 2);
                String newUrl = new String(decode2);
                System.out.println("Adf.ly response - " + newUrl);
                if (newUrl.toLowerCase().startsWith("http")) {
                    return this.redirectAndConnect(new URL(newUrl), target);
                }
            }
            if (target.getHost().equals("optifine.net") && !target.toString().contains("downloadx")) {
                key = content.toString().indexOf("downloadx");
                int after = content.toString().indexOf("\"", key);
                raw = content.toString().substring(key, after);
                String newUrl = target.getProtocol() + "://optifine.net/" + raw;
                return this.redirectAndConnect(new URL(newUrl), target);
            }
            if (content.toString().toLowerCase().replaceAll(" ", "").contains("http-equiv=\"refresh\"") && (key = content.toString().toLowerCase().indexOf("http", content.toString().toLowerCase().indexOf("url", content.toString().toLowerCase().indexOf("http-equiv")))) != -1) {
                String strDelim = content.toString().substring(content.toString().toLowerCase().indexOf("url", content.toString().toLowerCase().indexOf("http-equiv")), key).contains("'") ? "'" : "\"";
                String newUrl = content.toString().substring(key, content.toString().indexOf(strDelim, key));
                return this.redirectAndConnect(new URL(newUrl), target);
            }
            this.printMessage("File is in html format.  This may be an issue if an html file is not expected.");
        }
        conn.connect();
        return conn;
    }

    private String escapeURL(String source) {
        return source.replace(" ", "%20").replace("'", "%27").replace("[", "%5B").replace("]", "%5D");
    }

    private boolean nullOrEmpty(String input) {
        return input == null || input.isEmpty();
    }

    private void printMessage(String msg) {
        try {
            this.getTracker().getQueue().printMessage(this.filename + " - " + msg);
        }
        catch (NullPointerException npe) {
            System.out.println(this.filename + " - " + msg);
        }
    }

    public static String getHash(HashAlgorithm algo, File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        byte[] hash = algo == HashAlgorithm.MD5 ? DigestUtils.md5(is) : (algo == HashAlgorithm.SHA ? DigestUtils.sha(is) : new byte[]{});
        ((InputStream)is).close();
        return new String(Hex.encodeHex(hash));
    }

    public static File extractLZMA(File compressedFile) {
        File unpacked = new File(compressedFile.getParentFile(), compressedFile.getName().replace(".lzma", "").replace(".LZMA", ""));
        LZMAInputStream input = null;
        FileOutputStream output = null;
        try {
            input = new LZMAInputStream(new FileInputStream(compressedFile));
            output = new FileOutputStream(unpacked);
            byte[] buf = new byte[65536];
            int read = input.read(buf);
            while (read >= 1) {
                ((OutputStream)output).write(buf, 0, read);
                read = input.read(buf);
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Unable to extract lzma: " + e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                IOUtils.closeQuietly(output);
                compressedFile.delete();
                throw throwable;
            }
        }
        IOUtils.closeQuietly(input);
        IOUtils.closeQuietly(output);
        compressedFile.delete();
        return unpacked;
    }

    public static File extractXZ(File compressedFile) {
        File unpacked = new File(compressedFile.getParentFile(), compressedFile.getName().replace(".xz", "").replace(".XZ", ""));
        XZInputStream input = null;
        FileOutputStream output = null;
        try {
            input = new XZInputStream(new FileInputStream(compressedFile));
            output = new FileOutputStream(unpacked);
            byte[] buf = new byte[65536];
            int read = input.read(buf);
            while (read >= 1) {
                ((OutputStream)output).write(buf, 0, read);
                read = input.read(buf);
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Unable to extract xz: " + e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                IOUtils.closeQuietly(output);
                compressedFile.delete();
                throw throwable;
            }
        }
        IOUtils.closeQuietly(input);
        IOUtils.closeQuietly(output);
        compressedFile.delete();
        return unpacked;
    }

    public static File unpack(File compressedFile) {
        File unpacked = new File(compressedFile.getParentFile(), compressedFile.getName().replace(".pack", "").replace(".PACK", ""));
        JarOutputStream jarStream = null;
        try {
            jarStream = new JarOutputStream(new FileOutputStream(unpacked));
            Pack200.newUnpacker().unpack(compressedFile, jarStream);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Unable to unpack: " + e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(jarStream);
                compressedFile.delete();
                throw throwable;
            }
        }
        IOUtils.closeQuietly(jarStream);
        compressedFile.delete();
        return unpacked;
    }

    public static enum HashAlgorithm {
        MD5,
        SHA;

    }
}

