/*
 * Decompiled with CFR 0.152.
 */
package org.mcupdater.downloadlib;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Enumeration;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class SSLExpansion {
    private static SSLExpansion instance;
    private KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());

    public static SSLExpansion getInstance() {
        if (instance == null) {
            try {
                instance = new SSLExpansion();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return instance;
    }

    public SSLExpansion() throws Exception {
        Path ksPath = Paths.get(System.getProperty("java.home"), new String[0]).resolve("lib").resolve("security").resolve("cacerts");
        String ksPassword = "changeit";
        this.keyStore.load(Files.newInputStream(ksPath, new OpenOption[0]), ksPassword.toCharArray());
    }

    public void addCertificateFromStream(InputStream cert, String alias) throws Exception {
        Certificate ca = CertificateFactory.getInstance("X.509").generateCertificate(cert);
        this.keyStore.setCertificateEntry(alias, ca);
    }

    public void updateSSLContext() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(this.keyStore);
        Enumeration<String> elements = this.keyStore.aliases();
        while (elements.hasMoreElements()) {
            System.out.println("@ " + elements.nextElement());
        }
        System.out.println();
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(null, tmf.getTrustManagers(), null);
        HttpsURLConnection.setDefaultSSLSocketFactory(ctx.getSocketFactory());
    }
}

