/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.legacy8ujsse.sun.security.ssl;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.crypto.BadPaddingException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import org.openjsse.legacy8ujsse.sun.security.ssl.Authenticator;
import org.openjsse.legacy8ujsse.sun.security.ssl.CipherBox;
import org.openjsse.legacy8ujsse.sun.security.ssl.Debug;
import org.openjsse.legacy8ujsse.sun.security.ssl.HandshakeHash;
import org.openjsse.legacy8ujsse.sun.security.ssl.MAC;
import org.openjsse.legacy8ujsse.sun.security.ssl.ProtocolVersion;
import org.openjsse.legacy8ujsse.sun.security.ssl.Record;
import sun.misc.HexDumpEncoder;

class InputRecord
extends ByteArrayInputStream
implements Record {
    private HandshakeHash handshakeHash;
    private int lastHashed;
    boolean formatVerified = true;
    private boolean isClosed;
    private boolean appDataValid;
    private ProtocolVersion helloVersion;
    static final Debug debug = Debug.getInstance("ssl");
    private int exlen;
    private byte[] v2Buf;
    private static final byte[] v2NoCipher = new byte[]{-128, 3, 0, 0, 1};

    InputRecord() {
        super(new byte[16921]);
        this.setHelloVersion(ProtocolVersion.DEFAULT_HELLO);
        this.pos = 5;
        this.lastHashed = this.count = 5;
        this.exlen = 0;
        this.v2Buf = null;
    }

    void setHelloVersion(ProtocolVersion helloVersion) {
        this.helloVersion = helloVersion;
    }

    ProtocolVersion getHelloVersion() {
        return this.helloVersion;
    }

    void enableFormatChecks() {
        this.formatVerified = false;
    }

    boolean isAppDataValid() {
        return this.appDataValid;
    }

    void setAppDataValid(boolean value) {
        this.appDataValid = value;
    }

    byte contentType() {
        return this.buf[0];
    }

    void setHandshakeHash(HandshakeHash handshakeHash) {
        this.handshakeHash = handshakeHash;
    }

    HandshakeHash getHandshakeHash() {
        return this.handshakeHash;
    }

    void decrypt(Authenticator authenticator, CipherBox box) throws BadPaddingException {
        BadPaddingException reservedBPE = null;
        int tagLen = authenticator instanceof MAC ? ((MAC)authenticator).MAClen() : 0;
        int cipheredLength = this.count - 5;
        if (!box.isNullCipher()) {
            try {
                int nonceSize = box.applyExplicitNonce(authenticator, this.contentType(), this.buf, 5, cipheredLength);
                this.lastHashed = this.pos = 5 + nonceSize;
                int offset = 5;
                if (box.isAEADMode()) {
                    offset += nonceSize;
                }
                this.count = offset + box.decrypt(this.buf, offset, this.count - offset, tagLen);
            }
            catch (BadPaddingException bpe) {
                reservedBPE = bpe;
            }
        }
        if (authenticator instanceof MAC && tagLen != 0) {
            MAC signer = (MAC)authenticator;
            int macOffset = this.count - tagLen;
            int contentLen = macOffset - this.pos;
            if (contentLen < 0) {
                if (reservedBPE == null) {
                    reservedBPE = new BadPaddingException("bad record");
                }
                macOffset = 5 + cipheredLength - tagLen;
                contentLen = macOffset - 5;
            }
            this.count -= tagLen;
            if (InputRecord.checkMacTags(this.contentType(), this.buf, this.pos, contentLen, signer, false) && reservedBPE == null) {
                reservedBPE = new BadPaddingException("bad record MAC");
            }
            if (box.isCBCMode()) {
                int remainingLen = InputRecord.calculateRemainingLen(signer, cipheredLength, contentLen);
                if (remainingLen > this.buf.length) {
                    throw new RuntimeException("Internal buffer capacity error");
                }
                InputRecord.checkMacTags(this.contentType(), this.buf, 0, remainingLen, signer, true);
            }
        }
        if (reservedBPE != null) {
            throw reservedBPE;
        }
    }

    static boolean checkMacTags(byte contentType, byte[] buffer, int offset, int contentLen, MAC signer, boolean isSimulated) {
        int tagLen = signer.MAClen();
        byte[] hash = signer.compute(contentType, buffer, offset, contentLen, isSimulated);
        if (hash == null || tagLen != hash.length) {
            throw new RuntimeException("Internal MAC error");
        }
        int[] results = InputRecord.compareMacTags(buffer, offset + contentLen, hash);
        return results[0] != 0;
    }

    private static int[] compareMacTags(byte[] buffer, int offset, byte[] tag) {
        int[] results = new int[]{0, 0};
        for (int i = 0; i < tag.length; ++i) {
            if (buffer[offset + i] != tag[i]) {
                results[0] = results[0] + 1;
                continue;
            }
            results[1] = results[1] + 1;
        }
        return results;
    }

    static int calculateRemainingLen(MAC signer, int fullLen, int usedLen) {
        int blockLen = signer.hashBlockLen();
        int minimalPaddingLen = signer.minimalPaddingLen();
        return 1 + (int)(Math.ceil((double)(fullLen += 13 - (blockLen - minimalPaddingLen)) / (1.0 * (double)blockLen)) - Math.ceil((double)(usedLen += 13 - (blockLen - minimalPaddingLen)) / (1.0 * (double)blockLen))) * signer.hashBlockLen();
    }

    void ignore(int bytes) {
        if (bytes > 0) {
            this.pos += bytes;
            this.lastHashed = this.pos;
        }
    }

    void doHashes() {
        int len = this.pos - this.lastHashed;
        if (len > 0) {
            this.hashInternal(this.buf, this.lastHashed, len);
            this.lastHashed = this.pos;
        }
    }

    private void hashInternal(byte[] databuf, int offset, int len) {
        if (debug != null && Debug.isOn("data")) {
            try {
                HexDumpEncoder hd = new HexDumpEncoder();
                System.out.println("[read] MD5 and SHA1 hashes:  len = " + len);
                hd.encodeBuffer((InputStream)new ByteArrayInputStream(databuf, offset, len), (OutputStream)System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.handshakeHash.update(databuf, offset, len);
    }

    void queueHandshake(InputRecord r) throws IOException {
        int len;
        this.doHashes();
        if (this.pos > 5) {
            len = this.count - this.pos;
            if (len != 0) {
                System.arraycopy(this.buf, this.pos, this.buf, 5, len);
            }
            this.lastHashed = this.pos = 5;
            this.count = 5 + len;
        }
        if (this.buf.length < (len = r.available() + this.count)) {
            byte[] newbuf = new byte[len];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        System.arraycopy(r.buf, r.pos, this.buf, this.count, len - this.count);
        this.count = len;
        len = r.lastHashed - r.pos;
        if (this.pos == 5) {
            this.lastHashed += len;
        } else {
            throw new SSLProtocolException("?? confused buffer hashing ??");
        }
        r.pos = r.count;
    }

    @Override
    public void close() {
        this.appDataValid = false;
        this.isClosed = true;
        this.mark = 0;
        this.pos = 0;
        this.count = 0;
    }

    private int readFully(InputStream s, byte[] b, int off, int len) throws IOException {
        int n = 0;
        while (n < len) {
            int readLen = s.read(b, off + n, len - n);
            if (readLen < 0) {
                return readLen;
            }
            if (debug != null && Debug.isOn("packet")) {
                try {
                    HexDumpEncoder hd = new HexDumpEncoder();
                    ByteBuffer bb = ByteBuffer.wrap(b, off + n, readLen);
                    System.out.println("[Raw read]: length = " + bb.remaining());
                    hd.encodeBuffer(bb, (OutputStream)System.out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            n += readLen;
            this.exlen += readLen;
        }
        return n;
    }

    void read(InputStream s, OutputStream o) throws IOException {
        if (this.isClosed) {
            return;
        }
        if (this.exlen < 5) {
            int really = this.readFully(s, this.buf, this.exlen, 5 - this.exlen);
            if (really < 0) {
                throw new EOFException("SSL peer shut down incorrectly");
            }
            this.pos = 5;
            this.count = 5;
            this.lastHashed = this.pos;
        }
        if (!this.formatVerified) {
            this.formatVerified = true;
            if (this.buf[0] != 22 && this.buf[0] != 21) {
                this.handleUnknownRecord(s, o);
            } else {
                this.readV3Record(s, o);
            }
        } else {
            this.readV3Record(s, o);
        }
    }

    static void checkRecordVersion(ProtocolVersion version, boolean allowSSL20Hello) throws SSLException {
        if (!(version.v >= ProtocolVersion.MIN.v && (version.major & 0xFF) <= (ProtocolVersion.MAX.major & 0xFF) || allowSSL20Hello && version.v == ProtocolVersion.SSL20Hello.v)) {
            throw new SSLException("Unsupported record version " + version);
        }
    }

    private void readV3Record(InputStream s, OutputStream o) throws IOException {
        int really;
        ProtocolVersion recordVersion = ProtocolVersion.valueOf(this.buf[1], this.buf[2]);
        InputRecord.checkRecordVersion(recordVersion, false);
        int contentLen = ((this.buf[3] & 0xFF) << 8) + (this.buf[4] & 0xFF);
        if (contentLen < 0 || contentLen > 33300) {
            throw new SSLProtocolException("Bad InputRecord size, count = " + contentLen + ", buf.length = " + this.buf.length);
        }
        if (contentLen > this.buf.length - 5) {
            byte[] newbuf = new byte[contentLen + 5];
            System.arraycopy(this.buf, 0, newbuf, 0, 5);
            this.buf = newbuf;
        }
        if (this.exlen < contentLen + 5 && (really = this.readFully(s, this.buf, this.exlen, contentLen + 5 - this.exlen)) < 0) {
            throw new SSLException("SSL peer shut down incorrectly");
        }
        this.count = contentLen + 5;
        this.exlen = 0;
        if (debug != null && Debug.isOn("record")) {
            if (this.count < 0 || this.count > 16916) {
                System.out.println(Thread.currentThread().getName() + ", Bad InputRecord size, count = " + this.count);
            }
            System.out.println(Thread.currentThread().getName() + ", READ: " + recordVersion + " " + InputRecord.contentName(this.contentType()) + ", length = " + this.available());
        }
    }

    private void handleUnknownRecord(InputStream s, OutputStream o) throws IOException {
        if ((this.buf[0] & 0x80) != 0 && this.buf[2] == 1) {
            int really;
            if (this.helloVersion != ProtocolVersion.SSL20Hello) {
                throw new SSLHandshakeException("SSLv2Hello is disabled");
            }
            ProtocolVersion recordVersion = ProtocolVersion.valueOf(this.buf[3], this.buf[4]);
            if (recordVersion == ProtocolVersion.SSL20Hello) {
                try {
                    this.writeBuffer(o, v2NoCipher, 0, v2NoCipher.length);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new SSLException("Unsupported SSL v2.0 ClientHello");
            }
            int len = ((this.buf[0] & 0x7F) << 8) + (this.buf[1] & 0xFF) - 3;
            if (this.v2Buf == null) {
                this.v2Buf = new byte[len];
            }
            if (this.exlen < len + 5 && (really = this.readFully(s, this.v2Buf, this.exlen - 5, len + 5 - this.exlen)) < 0) {
                throw new EOFException("SSL peer shut down incorrectly");
            }
            this.exlen = 0;
            this.hashInternal(this.buf, 2, 3);
            this.hashInternal(this.v2Buf, 0, len);
            this.V2toV3ClientHello(this.v2Buf);
            this.v2Buf = null;
            this.lastHashed = this.count;
            if (debug != null && Debug.isOn("record")) {
                System.out.println(Thread.currentThread().getName() + ", READ:  SSL v2, contentType = " + InputRecord.contentName(this.contentType()) + ", translated length = " + this.available());
            }
            return;
        }
        if ((this.buf[0] & 0x80) != 0 && this.buf[2] == 4) {
            throw new SSLException("SSL V2.0 servers are not supported.");
        }
        for (int i = 0; i < v2NoCipher.length; ++i) {
            if (this.buf[i] == v2NoCipher[i]) continue;
            throw new SSLException("Unrecognized SSL message, plaintext connection?");
        }
        throw new SSLException("SSL V2.0 servers are not supported.");
    }

    void writeBuffer(OutputStream s, byte[] buf, int off, int len) throws IOException {
        s.write(buf, 0, len);
        s.flush();
    }

    private void V2toV3ClientHello(byte[] v2Msg) throws SSLException {
        int i;
        this.buf[0] = 22;
        this.buf[1] = this.buf[3];
        this.buf[2] = this.buf[4];
        this.buf[5] = 1;
        this.buf[9] = this.buf[1];
        this.buf[10] = this.buf[2];
        this.count = 11;
        int cipherSpecLen = ((v2Msg[0] & 0xFF) << 8) + (v2Msg[1] & 0xFF);
        int sessionIdLen = ((v2Msg[2] & 0xFF) << 8) + (v2Msg[3] & 0xFF);
        int nonceLen = ((v2Msg[4] & 0xFF) << 8) + (v2Msg[5] & 0xFF);
        int offset = 6 + cipherSpecLen + sessionIdLen;
        if (nonceLen < 32) {
            for (i = 0; i < 32 - nonceLen; ++i) {
                this.buf[this.count++] = 0;
            }
            System.arraycopy(v2Msg, offset, this.buf, this.count, nonceLen);
            this.count += nonceLen;
        } else {
            System.arraycopy(v2Msg, offset + (nonceLen - 32), this.buf, this.count, 32);
            this.count += 32;
        }
        this.buf[this.count++] = (byte)sessionIdLen;
        System.arraycopy(v2Msg, offset -= sessionIdLen, this.buf, this.count, sessionIdLen);
        this.count += sessionIdLen;
        offset -= cipherSpecLen;
        int j = this.count + 2;
        for (i = 0; i < cipherSpecLen; i += 3) {
            if (v2Msg[offset + i] != 0) continue;
            this.buf[j++] = v2Msg[offset + i + 1];
            this.buf[j++] = v2Msg[offset + i + 2];
        }
        this.buf[this.count++] = (byte)((j -= this.count + 2) >>> 8);
        this.buf[this.count++] = (byte)j;
        this.count += j;
        this.buf[this.count++] = 1;
        this.buf[this.count++] = 0;
        this.buf[3] = (byte)(this.count - 5);
        this.buf[4] = (byte)(this.count - 5 >>> 8);
        this.buf[6] = 0;
        this.buf[7] = (byte)(this.count - 5 - 4 >>> 8);
        this.buf[8] = (byte)(this.count - 5 - 4);
        this.pos = 5;
    }

    static String contentName(int contentType) {
        switch (contentType) {
            case 20: {
                return "Change Cipher Spec";
            }
            case 21: {
                return "Alert";
            }
            case 22: {
                return "Handshake";
            }
            case 23: {
                return "Application Data";
            }
        }
        return "contentType = " + contentType;
    }
}

