/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import javax.net.ssl.SSLHandshakeException;
import org.openjsse.sun.security.ssl.Alert;
import org.openjsse.sun.security.ssl.Authenticator;
import org.openjsse.sun.security.ssl.Ciphertext;
import org.openjsse.sun.security.ssl.ContentType;
import org.openjsse.sun.security.ssl.DTLSRecord;
import org.openjsse.sun.security.ssl.HandshakeHash;
import org.openjsse.sun.security.ssl.OutputRecord;
import org.openjsse.sun.security.ssl.ProtocolVersion;
import org.openjsse.sun.security.ssl.SSLCipher;
import org.openjsse.sun.security.ssl.SSLHandshake;
import org.openjsse.sun.security.ssl.SSLLogger;

final class DTLSOutputRecord
extends OutputRecord
implements DTLSRecord {
    private DTLSFragmenter fragmenter = null;
    int writeEpoch = 0;
    int prevWriteEpoch = 0;
    Authenticator prevWriteAuthenticator;
    SSLCipher.SSLWriteCipher prevWriteCipher = SSLCipher.SSLWriteCipher.nullDTlsWriteCipher();
    private volatile boolean isCloseWaiting = false;

    DTLSOutputRecord(HandshakeHash handshakeHash) {
        super(handshakeHash, SSLCipher.SSLWriteCipher.nullDTlsWriteCipher());
        this.packetSize = 16717;
        this.protocolVersion = ProtocolVersion.NONE;
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.isClosed) {
            if (this.fragmenter != null && this.fragmenter.hasAlert()) {
                this.isCloseWaiting = true;
            } else {
                super.close();
            }
        }
    }

    @Override
    boolean isClosed() {
        return this.isClosed || this.isCloseWaiting;
    }

    @Override
    void initHandshaker() {
        this.fragmenter = null;
    }

    @Override
    void finishHandshake() {
    }

    @Override
    void changeWriteCiphers(SSLCipher.SSLWriteCipher writeCipher, boolean useChangeCipherSpec) throws IOException {
        if (this.isClosed()) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("outbound has closed, ignore outbound change_cipher_spec message", new Object[0]);
            }
            return;
        }
        if (useChangeCipherSpec) {
            this.encodeChangeCipherSpec();
        }
        this.prevWriteCipher.dispose();
        this.prevWriteCipher = this.writeCipher;
        this.prevWriteEpoch = this.writeEpoch++;
        this.writeCipher = writeCipher;
        this.isFirstAppOutputRecord = true;
        this.writeCipher.authenticator.setEpochNumber(this.writeEpoch);
    }

    @Override
    void encodeAlert(byte level, byte description) throws IOException {
        if (this.isClosed()) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("outbound has closed, ignore outbound alert message: " + Alert.nameOf(description), new Object[0]);
            }
            return;
        }
        if (this.fragmenter == null) {
            this.fragmenter = new DTLSFragmenter();
        }
        this.fragmenter.queueUpAlert(level, description);
    }

    @Override
    void encodeChangeCipherSpec() throws IOException {
        if (this.isClosed()) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("outbound has closed, ignore outbound change_cipher_spec message", new Object[0]);
            }
            return;
        }
        if (this.fragmenter == null) {
            this.fragmenter = new DTLSFragmenter();
        }
        this.fragmenter.queueUpChangeCipherSpec();
    }

    @Override
    void encodeHandshake(byte[] source, int offset, int length) throws IOException {
        if (this.isClosed()) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("outbound has closed, ignore outbound handshake message", ByteBuffer.wrap(source, offset, length));
            }
            return;
        }
        if (this.firstMessage) {
            this.firstMessage = false;
        }
        if (this.fragmenter == null) {
            this.fragmenter = new DTLSFragmenter();
        }
        this.fragmenter.queueUpHandshake(source, offset, length);
    }

    @Override
    Ciphertext encode(ByteBuffer[] srcs, int srcsOffset, int srcsLength, ByteBuffer[] dsts, int dstsOffset, int dstsLength) throws IOException {
        if (this.isClosed) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("outbound has closed, ignore outbound application data or cached messages", new Object[0]);
            }
            return null;
        }
        if (this.isCloseWaiting) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("outbound has closed, ignore outbound application data", new Object[0]);
            }
            srcs = null;
        }
        return this.encode(srcs, srcsOffset, srcsLength, dsts[0]);
    }

    private Ciphertext encode(ByteBuffer[] sources, int offset, int length, ByteBuffer destination) throws IOException {
        int fragLen;
        Ciphertext ct;
        if (this.writeCipher.authenticator.seqNumOverflow()) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.fine("sequence number extremely close to overflow (2^64-1 packets). Closing connection.", new Object[0]);
            }
            throw new SSLHandshakeException("sequence number overflow");
        }
        if (!(this.isEmpty() && sources != null && sources.length != 0 || (ct = this.acquireCiphertext(destination)) == null)) {
            return ct;
        }
        if (sources == null || sources.length == 0) {
            return null;
        }
        int srcsRemains = 0;
        for (int i = offset; i < offset + length; ++i) {
            srcsRemains += sources[i].remaining();
        }
        if (srcsRemains == 0) {
            return null;
        }
        if (this.packetSize > 0) {
            fragLen = Math.min(16717, this.packetSize);
            fragLen = this.writeCipher.calculateFragmentSize(fragLen, 13);
            fragLen = Math.min(fragLen, 16384);
        } else {
            fragLen = 16384;
        }
        fragLen = this.calculateFragmentSize(fragLen);
        int dstPos = destination.position();
        int dstLim = destination.limit();
        int dstContent = dstPos + 13 + this.writeCipher.getExplicitNonceSize();
        destination.position(dstContent);
        int remains = Math.min(fragLen, destination.remaining());
        fragLen = 0;
        int srcsLen = offset + length;
        for (int i = offset; i < srcsLen && remains > 0; ++i) {
            int amount = Math.min(sources[i].remaining(), remains);
            int srcLimit = sources[i].limit();
            sources[i].limit(sources[i].position() + amount);
            destination.put(sources[i]);
            sources[i].limit(srcLimit);
            remains -= amount;
            fragLen += amount;
        }
        destination.limit(destination.position());
        destination.position(dstContent);
        if (SSLLogger.isOn && SSLLogger.isOn("record")) {
            SSLLogger.fine("WRITE: " + (Object)((Object)this.protocolVersion) + " " + ContentType.APPLICATION_DATA.name + ", length = " + destination.remaining(), new Object[0]);
        }
        long recordSN = DTLSOutputRecord.encrypt(this.writeCipher, ContentType.APPLICATION_DATA.id, destination, dstPos, dstLim, 13, this.protocolVersion);
        if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
            ByteBuffer temporary = destination.duplicate();
            temporary.limit(temporary.position());
            temporary.position(dstPos);
            SSLLogger.fine("Raw write", temporary);
        }
        destination.limit(dstLim);
        return new Ciphertext(ContentType.APPLICATION_DATA.id, SSLHandshake.NOT_APPLICABLE.id, recordSN);
    }

    private Ciphertext acquireCiphertext(ByteBuffer destination) throws IOException {
        if (this.fragmenter != null) {
            return this.fragmenter.acquireCiphertext(destination);
        }
        return null;
    }

    @Override
    boolean isEmpty() {
        return this.fragmenter == null || this.fragmenter.isEmpty();
    }

    @Override
    void launchRetransmission() {
        if (this.fragmenter != null && this.fragmenter.isRetransmittable()) {
            this.fragmenter.setRetransmission();
        }
    }

    private final class DTLSFragmenter {
        private final LinkedList<RecordMemo> handshakeMemos = new LinkedList();
        private int acquireIndex = 0;
        private int messageSequence = 0;
        private boolean flightIsReady = false;
        private int retransmits = 2;

        private DTLSFragmenter() {
        }

        void queueUpHandshake(byte[] buf, int offset, int length) throws IOException {
            if (this.flightIsReady) {
                this.handshakeMemos.clear();
                this.acquireIndex = 0;
                this.flightIsReady = false;
            }
            HandshakeMemo memo = new HandshakeMemo();
            memo.contentType = ContentType.HANDSHAKE.id;
            memo.majorVersion = DTLSOutputRecord.this.protocolVersion.major;
            memo.minorVersion = DTLSOutputRecord.this.protocolVersion.minor;
            memo.encodeEpoch = DTLSOutputRecord.this.writeEpoch;
            memo.encodeCipher = DTLSOutputRecord.this.writeCipher;
            memo.handshakeType = buf[offset];
            memo.messageSequence = this.messageSequence++;
            memo.acquireOffset = 0;
            memo.fragment = new byte[length - 4];
            System.arraycopy(buf, offset + 4, memo.fragment, 0, length - 4);
            this.handshakeHashing(memo, memo.fragment);
            this.handshakeMemos.add(memo);
            if (memo.handshakeType == SSLHandshake.CLIENT_HELLO.id || memo.handshakeType == SSLHandshake.HELLO_REQUEST.id || memo.handshakeType == SSLHandshake.HELLO_VERIFY_REQUEST.id || memo.handshakeType == SSLHandshake.SERVER_HELLO_DONE.id || memo.handshakeType == SSLHandshake.FINISHED.id) {
                this.flightIsReady = true;
            }
        }

        void queueUpChangeCipherSpec() {
            if (this.flightIsReady) {
                this.handshakeMemos.clear();
                this.acquireIndex = 0;
                this.flightIsReady = false;
            }
            RecordMemo memo = new RecordMemo();
            memo.contentType = ContentType.CHANGE_CIPHER_SPEC.id;
            memo.majorVersion = DTLSOutputRecord.this.protocolVersion.major;
            memo.minorVersion = DTLSOutputRecord.this.protocolVersion.minor;
            memo.encodeEpoch = DTLSOutputRecord.this.writeEpoch;
            memo.encodeCipher = DTLSOutputRecord.this.writeCipher;
            memo.fragment = new byte[1];
            memo.fragment[0] = 1;
            this.handshakeMemos.add(memo);
        }

        void queueUpAlert(byte level, byte description) throws IOException {
            RecordMemo memo = new RecordMemo();
            memo.contentType = ContentType.ALERT.id;
            memo.majorVersion = DTLSOutputRecord.this.protocolVersion.major;
            memo.minorVersion = DTLSOutputRecord.this.protocolVersion.minor;
            memo.encodeEpoch = DTLSOutputRecord.this.writeEpoch;
            memo.encodeCipher = DTLSOutputRecord.this.writeCipher;
            memo.fragment = new byte[2];
            memo.fragment[0] = level;
            memo.fragment[1] = description;
            this.handshakeMemos.add(memo);
        }

        Ciphertext acquireCiphertext(ByteBuffer dstBuf) throws IOException {
            int fragLen;
            if (this.isEmpty()) {
                if (this.isRetransmittable()) {
                    this.setRetransmission();
                } else {
                    return null;
                }
            }
            RecordMemo memo = this.handshakeMemos.get(this.acquireIndex);
            HandshakeMemo hsMemo = null;
            if (memo.contentType == ContentType.HANDSHAKE.id) {
                hsMemo = (HandshakeMemo)memo;
            }
            if (DTLSOutputRecord.this.packetSize > 0) {
                fragLen = Math.min(16717, DTLSOutputRecord.this.packetSize);
                fragLen = memo.encodeCipher.calculateFragmentSize(fragLen, 25);
                fragLen = Math.min(fragLen, 16384);
            } else {
                fragLen = 16384;
            }
            fragLen = DTLSOutputRecord.this.calculateFragmentSize(fragLen);
            int dstPos = dstBuf.position();
            int dstLim = dstBuf.limit();
            int dstContent = dstPos + 13 + memo.encodeCipher.getExplicitNonceSize();
            dstBuf.position(dstContent);
            if (hsMemo != null) {
                fragLen = Math.min(fragLen, hsMemo.fragment.length - hsMemo.acquireOffset);
                dstBuf.put(hsMemo.handshakeType);
                dstBuf.put((byte)(hsMemo.fragment.length >> 16 & 0xFF));
                dstBuf.put((byte)(hsMemo.fragment.length >> 8 & 0xFF));
                dstBuf.put((byte)(hsMemo.fragment.length & 0xFF));
                dstBuf.put((byte)(hsMemo.messageSequence >> 8 & 0xFF));
                dstBuf.put((byte)(hsMemo.messageSequence & 0xFF));
                dstBuf.put((byte)(hsMemo.acquireOffset >> 16 & 0xFF));
                dstBuf.put((byte)(hsMemo.acquireOffset >> 8 & 0xFF));
                dstBuf.put((byte)(hsMemo.acquireOffset & 0xFF));
                dstBuf.put((byte)(fragLen >> 16 & 0xFF));
                dstBuf.put((byte)(fragLen >> 8 & 0xFF));
                dstBuf.put((byte)(fragLen & 0xFF));
                dstBuf.put(hsMemo.fragment, hsMemo.acquireOffset, fragLen);
            } else {
                fragLen = Math.min(fragLen, memo.fragment.length);
                dstBuf.put(memo.fragment, 0, fragLen);
            }
            dstBuf.limit(dstBuf.position());
            dstBuf.position(dstContent);
            if (SSLLogger.isOn && SSLLogger.isOn("record")) {
                SSLLogger.fine("WRITE: " + (Object)((Object)DTLSOutputRecord.this.protocolVersion) + " " + ContentType.nameOf(memo.contentType) + ", length = " + dstBuf.remaining(), new Object[0]);
            }
            long recordSN = OutputRecord.encrypt(memo.encodeCipher, memo.contentType, dstBuf, dstPos, dstLim, 13, ProtocolVersion.valueOf(memo.majorVersion, memo.minorVersion));
            if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
                ByteBuffer temporary = dstBuf.duplicate();
                temporary.limit(temporary.position());
                temporary.position(dstPos);
                SSLLogger.fine("Raw write (" + temporary.remaining() + ")", temporary);
            }
            dstBuf.limit(dstLim);
            if (hsMemo != null) {
                hsMemo.acquireOffset += fragLen;
                if (hsMemo.acquireOffset == hsMemo.fragment.length) {
                    ++this.acquireIndex;
                }
                return new Ciphertext(hsMemo.contentType, hsMemo.handshakeType, recordSN);
            }
            if (DTLSOutputRecord.this.isCloseWaiting && memo.contentType == ContentType.ALERT.id) {
                DTLSOutputRecord.this.close();
            }
            ++this.acquireIndex;
            return new Ciphertext(memo.contentType, SSLHandshake.NOT_APPLICABLE.id, recordSN);
        }

        private void handshakeHashing(HandshakeMemo hsFrag, byte[] hsBody) {
            byte[] temporary;
            byte hsType = hsFrag.handshakeType;
            if (!DTLSOutputRecord.this.handshakeHash.isHashable(hsType)) {
                return;
            }
            temporary = new byte[]{hsFrag.handshakeType, (byte)(hsBody.length >> 16 & 0xFF), (byte)(hsBody.length >> 8 & 0xFF), (byte)(hsBody.length & 0xFF), (byte)(hsFrag.messageSequence >> 8 & 0xFF), (byte)(hsFrag.messageSequence & 0xFF), 0, 0, 0, temporary[1], temporary[2], temporary[3]};
            DTLSOutputRecord.this.handshakeHash.deliver(temporary, 0, 12);
            DTLSOutputRecord.this.handshakeHash.deliver(hsBody, 0, hsBody.length);
        }

        boolean isEmpty() {
            return !this.flightIsReady || this.handshakeMemos.isEmpty() || this.acquireIndex >= this.handshakeMemos.size();
        }

        boolean hasAlert() {
            for (RecordMemo memo : this.handshakeMemos) {
                if (memo.contentType != ContentType.ALERT.id) continue;
                return true;
            }
            return false;
        }

        boolean isRetransmittable() {
            return this.flightIsReady && !this.handshakeMemos.isEmpty() && this.acquireIndex >= this.handshakeMemos.size();
        }

        private void setRetransmission() {
            this.acquireIndex = 0;
            for (RecordMemo memo : this.handshakeMemos) {
                if (!(memo instanceof HandshakeMemo)) continue;
                HandshakeMemo hmemo = (HandshakeMemo)memo;
                hmemo.acquireOffset = 0;
            }
            if (DTLSOutputRecord.this.packetSize <= 16717 && DTLSOutputRecord.this.packetSize > 256 && this.retransmits-- <= 0) {
                this.shrinkPacketSize();
                this.retransmits = 2;
            }
        }

        private void shrinkPacketSize() {
            DTLSOutputRecord.this.packetSize = Math.max(256, DTLSOutputRecord.this.packetSize / 2);
        }
    }

    private static class HandshakeMemo
    extends RecordMemo {
        byte handshakeType;
        int messageSequence;
        int acquireOffset;

        private HandshakeMemo() {
        }
    }

    private static class RecordMemo {
        byte contentType;
        byte majorVersion;
        byte minorVersion;
        int encodeEpoch;
        SSLCipher.SSLWriteCipher encodeCipher;
        byte[] fragment;

        private RecordMemo() {
        }
    }
}

