/*
 * Decompiled with CFR 0.152.
 */
package org.mcupdater.downloadlib;

import org.mcupdater.downloadlib.DownloadQueue;

public class ProgressTracker {
    private long total;
    private long current;
    private DownloadQueue queue;

    public DownloadQueue getQueue() {
        return this.queue;
    }

    public void setQueue(DownloadQueue queue) {
        this.queue = queue;
    }

    public long getCurrent() {
        return this.current;
    }

    public void setCurrent(long current) {
        this.current = current;
        if (current > this.total) {
            this.total = current;
        }
        if (this.queue != null) {
            this.queue.updateProgress();
        }
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
        if (this.queue != null) {
            this.queue.updateProgress();
        }
    }

    public void addProgress(long amount) {
        this.setCurrent(this.getCurrent() + amount);
    }

    public float getProgress() {
        if (this.total == 0L) {
            return 0.0f;
        }
        return (float)this.current / (float)this.total;
    }
}

