/*
 * Decompiled with CFR 0.152.
 */
package org.mcupdater.downloadlib;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TaskableExecutor
extends ThreadPoolExecutor {
    final Runnable after;
    private boolean taskCompleted = false;

    public TaskableExecutor(int threads, Runnable after) {
        super(0, threads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.after = after;
        if (after == null) {
            this.taskCompleted = true;
        }
    }

    @Override
    public void afterExecute(Runnable task, Throwable thrown) {
        super.afterExecute(task, thrown);
        System.out.println("Checking for post-download action thread.");
        if (this.getQueue().size() == 0) {
            System.out.println("Starting thread.");
            Thread taskThread = new Thread(this.after);
            taskThread.start();
            while (taskThread.isAlive()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            System.out.println("DEBUG - afterExecute() completed");
            this.taskCompleted = true;
        }
    }

    public boolean isTaskCompleted() {
        return this.taskCompleted;
    }

    @Override
    public boolean isShutdown() {
        return super.isShutdown() && this.taskCompleted;
    }
}

