/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.transforms.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.Transform;
import com.sun.org.apache.xml.internal.security.transforms.TransformSpi;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Element;

public class TransformXSLT
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/TR/1999/REC-xslt-19991116";
    static final String XSLTSpecNS = "http://www.w3.org/1999/XSL/Transform";
    static final String defaultXSLTSpecNSprefix = "xslt";
    static final String XSLTSTYLESHEET = "stylesheet";
    private static final Logger LOG = Logger.getLogger(TransformXSLT.class.getName());

    @Override
    protected String engineGetURI() {
        return implementedTransformURI;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput xMLSignatureInput, OutputStream outputStream, Transform transform) throws IOException, TransformationException {
        try {
            StreamSource streamSource;
            Object object;
            Source source;
            Object object2;
            Element element = transform.getElement();
            Element element2 = XMLUtils.selectNode(element.getFirstChild(), XSLTSpecNS, XSLTSTYLESHEET, 0);
            if (element2 == null) {
                element2 = XMLUtils.selectNode(element.getFirstChild(), XSLTSpecNS, "transform", 0);
            }
            if (element2 == null) {
                Object[] objectArray = new Object[]{"xslt:stylesheet", "Transform"};
                throw new TransformationException("xml.WrongContent", objectArray);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            Object object3 = new ByteArrayOutputStream();
            Object object4 = null;
            try {
                object2 = transformerFactory.newTransformer();
                source = new DOMSource(element2);
                object = new StreamResult((OutputStream)object3);
                ((Transformer)object2).transform(source, (Result)object);
                streamSource = new StreamSource(new ByteArrayInputStream(((ByteArrayOutputStream)object3).toByteArray()));
            }
            catch (Throwable throwable) {
                object4 = throwable;
                throw throwable;
            }
            finally {
                if (object3 != null) {
                    if (object4 != null) {
                        try {
                            ((ByteArrayOutputStream)object3).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object4).addSuppressed(throwable);
                        }
                    } else {
                        ((ByteArrayOutputStream)object3).close();
                    }
                }
            }
            object3 = transformerFactory.newTransformer(streamSource);
            try {
                ((Transformer)object3).setOutputProperty("{http://xml.apache.org/xalan}line-separator", "\n");
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Unable to set Xalan line-separator property: " + exception.getMessage());
            }
            object4 = new ByteArrayInputStream(xMLSignatureInput.getBytes());
            object2 = null;
            try {
                source = new StreamSource((InputStream)object4);
                if (outputStream == null) {
                    object = new ByteArrayOutputStream();
                    Throwable throwable = null;
                    try {
                        StreamResult streamResult = new StreamResult((OutputStream)object);
                        ((Transformer)object3).transform(source, streamResult);
                        XMLSignatureInput xMLSignatureInput2 = new XMLSignatureInput(((ByteArrayOutputStream)object).toByteArray());
                        xMLSignatureInput2.setSecureValidation(this.secureValidation);
                        XMLSignatureInput xMLSignatureInput3 = xMLSignatureInput2;
                        return xMLSignatureInput3;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (object != null) {
                            if (throwable != null) {
                                try {
                                    ((ByteArrayOutputStream)object).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((ByteArrayOutputStream)object).close();
                            }
                        }
                    }
                }
                object = new StreamResult(outputStream);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            ((Transformer)object3).transform(source, (Result)object);
            object4 = new XMLSignatureInput((byte[])null);
            ((XMLSignatureInput)object4).setSecureValidation(this.secureValidation);
            ((XMLSignatureInput)object4).setOutputStream(outputStream);
            return object4;
            finally {
                if (object4 != null) {
                    if (object2 != null) {
                        try {
                            ((InputStream)object4).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)object4).close();
                    }
                }
            }
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new TransformationException(xMLSecurityException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new TransformationException(transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new TransformationException(transformerException);
        }
    }
}

