/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import com.sun.org.apache.xml.internal.security.algorithms.MessageDigestAlgorithm;
import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DigesterOutputStream
extends ByteArrayOutputStream {
    private static final Logger LOG = Logger.getLogger(DigesterOutputStream.class.getName());
    final MessageDigestAlgorithm mda;

    public DigesterOutputStream(MessageDigestAlgorithm messageDigestAlgorithm) {
        this.mda = messageDigestAlgorithm;
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n) {
        this.mda.update((byte)n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Pre-digested input:");
            StringBuilder stringBuilder = new StringBuilder(n2);
            for (int i = n; i < n + n2; ++i) {
                stringBuilder.append((char)byArray[i]);
            }
            LOG.log(Level.FINE, stringBuilder.toString());
        }
        this.mda.update(byArray, n, n2);
    }

    public byte[] getDigestValue() {
        return this.mda.digest();
    }
}

