/*
 * Decompiled with CFR 0.152.
 */
package org.openjsse.com.sun.net.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.openjsse.com.sun.net.ssl.KeyManager;
import org.openjsse.com.sun.net.ssl.KeyManagerFactorySpi;
import org.openjsse.com.sun.net.ssl.SSLSecurity;
import org.openjsse.com.sun.net.ssl.X509KeyManagerComSunWrapper;

final class KeyManagerFactorySpiWrapper
extends KeyManagerFactorySpi {
    private KeyManagerFactory theKeyManagerFactory;

    KeyManagerFactorySpiWrapper(String algName, Provider prov) throws NoSuchAlgorithmException {
        this.theKeyManagerFactory = KeyManagerFactory.getInstance(algName, prov);
    }

    @Override
    protected void engineInit(KeyStore ks, char[] password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.theKeyManagerFactory.init(ks, password);
    }

    @Override
    protected KeyManager[] engineGetKeyManagers() {
        int src;
        javax.net.ssl.KeyManager[] kma = this.theKeyManagerFactory.getKeyManagers();
        Object[] kmaw = new KeyManager[kma.length];
        int dst = 0;
        for (src = 0; src < kma.length; ++src) {
            if (!(kma[src] instanceof KeyManager)) {
                if (!(kma[src] instanceof X509KeyManager)) continue;
                kmaw[dst] = new X509KeyManagerComSunWrapper((X509KeyManager)kma[src]);
                ++dst;
                continue;
            }
            kmaw[dst] = (KeyManager)((Object)kma[src]);
            ++dst;
        }
        if (dst != src) {
            kmaw = (KeyManager[])SSLSecurity.truncateArray(kmaw, new KeyManager[dst]);
        }
        return kmaw;
    }
}

